import {use, useEffect, useState} from 'react'



function LinkList() {
    const [data, setData] = useState({});
    const [error, setError] = useState({});
    const [loading, setLoading] = useState(true);
    const filterArray = ["provider", "medicare","employer", "individual"];
    useEffect(() => {
        fetch('http://localhost:8080/magnoliaAuthor/.rest/delivery/links-app')
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP error! status: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {

                setData(data.results);
                setLoading(false);
            })
            .catch(error => {
                console.log('here is the error ' ,error)
                setError(error);
                setLoading(false);
            });
    }, []); // Empty dependency array ensures this runs only once on mount

    if (loading) return <p>Loading...</p>;
    if (error.message) return <p>Message: {error.code} - Error: {error.message}</p>;
    if (!data) return null;

    return (
        <>
            <ul>


                {
                    data.filter(item =>
                        filterArray.some(filterItem => filterItem == item.name) ).map(item => {


                            return <li key={item.id}><a href={item["@path"]}>{item.title}</a></li>
                        }
                    )}
            </ul>
        </>
    )
}

export default LinkList