import { EditableComponent } from '@magnolia/react-editor';
import PropTypes from 'prop-types';

const Footer = ({ content }) => {
  return (
    <footer className='bg-dark-teal text-white px-8'>
      <div className='grid grid-cols-3 gap-12'>
        <a href='https://www.magnolia-cms.com' target='_blank' rel='noreferrer'>
          <img
            className='py-6 max-w-64'
            src='/Magnolia_icon_white.svg'
            alt='Magnolia Logo'
          />
        </a>
        <div className='col-span-2'>
          {content['@nodes'].map((node) => (
            <EditableComponent
              key={content[node]['@id']}
              content={content[node]}
            />
          ))}
        </div>
      </div>
      <div className='text-center text-light-green py-6'>
        <p>2024 Magnolia International Ltd. Some rights reserved.</p>
      </div>
    </footer>
  );
};

Footer.propTypes = {
  content: PropTypes.object,
};

export default Footer;
