import CreatePagePlugin from "@magnolia/cli-create-page-plugin";
import CreateComponentPlugin from "@magnolia/cli-create-component-plugin";
import CreateVirtualUriPlugin from "@magnolia/cli-create-virtual-uri-plugin";
import CreateContentTypePlugin from "@magnolia/cli-create-content-type-plugin";
import CreateAppPlugin from "@magnolia/cli-create-app-plugin";
import CreateLightModulePlugin from "@magnolia/cli-create-light-module-plugin";
import StartPlugin from "@magnolia/cli-start-plugin";
export default {
  analytics: {
    enabled: true,
    // Set to false to turn off analytics
    uuid: "120dfcc7-ef89-4b6a-9d71-ef7c0946fa29"
  },
  // Logger configuration
  // see: https://github.com/winstonjs/winston#logging for logging levels explanation
  logger: {
    filename: "./mgnl.error.log",
    fileLevel: "debug",
    consoleLevel: "info"
  },
  // Here you can add plugins you want to use with MGNL CLI
  plugins: [new CreatePagePlugin({
      pagesSpaPath: './spa/src/app/templates/pages',
      framework: '@magnolia/cli-react-prototypes',
      prototype: 'mhd',
      templateData: {
        port: '8181'
      }
    }), new CreateComponentPlugin({
      componentsSpaPath: './spa/src/app/templates/components',
      framework: '@magnolia/cli-react-prototypes',
      prototype: 'mhd'
    }), new CreateVirtualUriPlugin(),
    new CreateContentTypePlugin(),
    new CreateAppPlugin(),
    new CreateLightModulePlugin(),
    new StartPlugin({
      tomcatPath: './.magnolia/apache-tomcat'
    })
  ],
  type: "jsx",
  lightModulesPath: "./light-modules",
  lightModule: "spa-lm",
  componentMappingFilePath: "./spa/src/magnolia.config.js"
};
